/*
 * Decompiled with CFR 0.152.
 */
package emulator.util;

import java.util.Observable;

public class SynchronizedFlag
extends Observable {
    boolean value = false;

    public synchronized void setValue(boolean new_value) {
        boolean has_changed = this.value ^ new_value;
        this.value = new_value;
        this.notifyAll();
        if (has_changed) {
            this.touch();
        }
    }

    public synchronized void waitForValue(boolean target_value) throws InterruptedException {
        while (this.value != target_value) {
            this.wait();
        }
    }

    public void touch() {
        this.setChanged();
        this.notifyObservers(this.value);
    }

    public boolean getValue() {
        return this.value;
    }
}

